/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.core.IPlayerWaystoneData;
import net.blay09.mods.waystones.core.WaystoneManagerImpl;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class PersistentPlayerWaystoneData
implements IPlayerWaystoneData {
    private static final String TAG_NAME = "WaystonesData";
    private static final String ACTIVATED_WAYSTONES = "Waystones";
    private static final String SORTING_INDEX = "SortingIndex";
    private static final String COOLDOWNS = "Cooldowns";

    @Override
    public void activateWaystone(class_1657 player, Waystone waystone) {
        class_2499 activatedWaystonesData = PersistentPlayerWaystoneData.getActivatedWaystonesData(PersistentPlayerWaystoneData.getWaystonesData(player));
        activatedWaystonesData.add((Object)class_2519.method_23256((String)waystone.getWaystoneUid().toString()));
    }

    @Override
    public boolean isWaystoneActivated(class_1657 player, Waystone waystone) {
        class_2499 activatedWaystones = PersistentPlayerWaystoneData.getActivatedWaystonesData(PersistentPlayerWaystoneData.getWaystonesData(player));
        String waystoneUid = waystone.getWaystoneUid().toString();
        for (class_2520 activatedWaystone : activatedWaystones) {
            if (!waystoneUid.equals(activatedWaystone.method_10714())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<Waystone> getWaystones(class_1657 player) {
        class_2499 activatedWaystonesTag = PersistentPlayerWaystoneData.getActivatedWaystonesData(PersistentPlayerWaystoneData.getWaystonesData(player));
        ArrayList<Waystone> waystones = new ArrayList<Waystone>();
        Iterator iterator = activatedWaystonesTag.iterator();
        while (iterator.hasNext()) {
            class_2520 activatedWaystoneTag = (class_2520)iterator.next();
            WaystoneProxy proxy = new WaystoneProxy(player.method_5682(), UUID.fromString(activatedWaystoneTag.method_10714()));
            if (proxy.isValid()) {
                waystones.add(proxy);
                continue;
            }
            iterator.remove();
        }
        return waystones;
    }

    @Override
    public List<UUID> getSortingIndex(class_1657 player) {
        class_2499 sortingIndex = PersistentPlayerWaystoneData.getSortingIndexData(PersistentPlayerWaystoneData.getWaystonesData(player));
        return sortingIndex.stream().map(entry -> UUID.fromString(entry.method_10714())).toList();
    }

    @Override
    public void setSortingIndex(class_1657 player, List<UUID> sortingIndex) {
        class_2499 sortingIndexData = PersistentPlayerWaystoneData.getSortingIndexData(PersistentPlayerWaystoneData.getWaystonesData(player));
        sortingIndexData.clear();
        for (UUID waystoneUid : sortingIndex) {
            sortingIndexData.add((Object)class_2519.method_23256((String)waystoneUid.toString()));
        }
    }

    @Override
    public List<UUID> ensureSortingIndex(class_1657 player, Collection<Waystone> waystones) {
        UUID waystoneUid;
        class_2499 sortingIndexData = PersistentPlayerWaystoneData.getSortingIndexData(PersistentPlayerWaystoneData.getWaystonesData(player));
        ArrayList<UUID> sortingIndex = new ArrayList<UUID>();
        HashSet<UUID> existing = new HashSet<UUID>();
        for (class_2520 sortingIndexEntry : sortingIndexData) {
            waystoneUid = UUID.fromString(sortingIndexEntry.method_10714());
            if (!existing.add(waystoneUid)) continue;
            sortingIndex.add(waystoneUid);
        }
        for (Waystone waystone : waystones) {
            waystoneUid = waystone.getWaystoneUid();
            if (existing.contains(waystoneUid)) continue;
            sortingIndex.add(waystoneUid);
            sortingIndexData.add((Object)class_2519.method_23256((String)waystoneUid.toString()));
        }
        return sortingIndex;
    }

    @Override
    public void sortWaystoneAsFirst(class_1657 player, UUID waystoneUid) {
        class_2499 sortingIndex = PersistentPlayerWaystoneData.getSortingIndexData(PersistentPlayerWaystoneData.getWaystonesData(player));
        for (int i = 0; i < sortingIndex.size(); ++i) {
            class_2520 sortingIndexEntry = sortingIndex.method_10534(i);
            if (!waystoneUid.toString().equals(sortingIndexEntry.method_10714())) continue;
            sortingIndex.method_10536(i);
            sortingIndex.method_10531(0, sortingIndexEntry);
            break;
        }
    }

    @Override
    public void sortWaystoneAsLast(class_1657 player, UUID waystoneUid) {
        class_2499 sortingIndex = PersistentPlayerWaystoneData.getSortingIndexData(PersistentPlayerWaystoneData.getWaystonesData(player));
        for (int i = 0; i < sortingIndex.size(); ++i) {
            class_2520 sortingIndexEntry = sortingIndex.method_10534(i);
            if (!waystoneUid.toString().equals(sortingIndexEntry.method_10714())) continue;
            sortingIndex.method_10536(i);
            sortingIndex.add((Object)sortingIndexEntry);
            break;
        }
    }

    @Override
    public void sortWaystoneSwap(class_1657 player, UUID waystoneUid, UUID otherWaystoneUid) {
        class_2499 sortingIndex = PersistentPlayerWaystoneData.getSortingIndexData(PersistentPlayerWaystoneData.getWaystonesData(player));
        int waystoneIndex = -1;
        int otherWaystoneIndex = -1;
        for (int i = 0; i < sortingIndex.size(); ++i) {
            class_2520 sortingIndexEntry = sortingIndex.method_10534(i);
            if (waystoneUid.toString().equals(sortingIndexEntry.method_10714())) {
                waystoneIndex = i;
                continue;
            }
            if (!otherWaystoneUid.toString().equals(sortingIndexEntry.method_10714())) continue;
            otherWaystoneIndex = i;
        }
        if (waystoneIndex != -1 && otherWaystoneIndex != -1) {
            Collections.swap(sortingIndex, waystoneIndex, otherWaystoneIndex);
        }
    }

    @Override
    public void deactivateWaystone(class_1657 player, Waystone waystone) {
        class_2487 data = PersistentPlayerWaystoneData.getWaystonesData(player);
        class_2499 activatedWaystones = PersistentPlayerWaystoneData.getActivatedWaystonesData(data);
        String waystoneUid = waystone.getWaystoneUid().toString();
        for (int i = activatedWaystones.size() - 1; i >= 0; --i) {
            class_2520 activatedWaystone = activatedWaystones.method_10534(i);
            if (!waystoneUid.equals(activatedWaystone.method_10714())) continue;
            activatedWaystones.method_10536(i);
            break;
        }
    }

    @Override
    public Map<class_2960, Long> getCooldowns(class_1657 player) {
        class_2487 waystonesData = PersistentPlayerWaystoneData.getWaystonesData(player);
        class_2487 cooldowns = waystonesData.method_10562(COOLDOWNS);
        HashMap<class_2960, Long> cooldownMap = new HashMap<class_2960, Long>();
        for (String key : cooldowns.method_10541()) {
            cooldownMap.put(class_2960.method_60654((String)key), cooldowns.method_10537(key));
        }
        return cooldownMap;
    }

    @Override
    public void resetCooldowns(class_1657 player) {
        class_2487 waystonesData = PersistentPlayerWaystoneData.getWaystonesData(player);
        waystonesData.method_10566(COOLDOWNS, (class_2520)new class_2487());
    }

    @Override
    public long getCooldownUntil(class_1657 player, class_2960 key) {
        class_2487 waystonesData = PersistentPlayerWaystoneData.getWaystonesData(player);
        class_2487 cooldowns = waystonesData.method_10562(COOLDOWNS);
        return cooldowns.method_10537(key.toString());
    }

    @Override
    public void setCooldownUntil(class_1657 player, class_2960 key, long timeStamp) {
        class_2487 waystonesData = PersistentPlayerWaystoneData.getWaystonesData(player);
        class_2487 cooldowns = waystonesData.method_10562(COOLDOWNS);
        cooldowns.method_10544(key.toString(), timeStamp);
        waystonesData.method_10566(COOLDOWNS, (class_2520)cooldowns);
    }

    private static class_2499 getActivatedWaystonesData(class_2487 data) {
        class_2499 list = data.method_10554(ACTIVATED_WAYSTONES, 8);
        data.method_10566(ACTIVATED_WAYSTONES, (class_2520)list);
        return list;
    }

    private static class_2499 getSortingIndexData(class_2487 data) {
        class_2499 list = data.method_10545(SORTING_INDEX) ? data.method_10554(SORTING_INDEX, 8) : PersistentPlayerWaystoneData.createSortingIndexFromLegacy(data);
        data.method_10566(SORTING_INDEX, (class_2520)list);
        return list;
    }

    private static class_2487 getWaystonesData(class_1657 player) {
        class_2487 persistedData = Balm.getHooks().getPersistentData(player);
        class_2487 compound = persistedData.method_10562(TAG_NAME);
        persistedData.method_10566(TAG_NAME, (class_2520)compound);
        return compound;
    }

    private static class_2499 createSortingIndexFromLegacy(class_2487 data) {
        class_2499 activatedWaystones = PersistentPlayerWaystoneData.getActivatedWaystonesData(data);
        if (activatedWaystones.isEmpty()) {
            return new class_2499();
        }
        class_2499 sortingIndex = new class_2499();
        sortingIndex.addAll((Collection)activatedWaystones);
        return sortingIndex;
    }

    @Override
    public Optional<Waystone> findWaystoneByName(class_1657 player, String name) {
        return WaystoneManagerImpl.get(player.method_5682()).findWaystoneByName(name);
    }
}

